<?php
//necesitas la libreria composer require setasign/fpdi


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Recoger datos del formulario
    $name = isset($_POST['name']) ? trim($_POST['name']) : '';
    $signatureData = isset($_POST['signature']) ? $_POST['signature'] : '';

    if (empty($name) || empty($signatureData)) {
        echo "Nombre y firma son requeridos.";
        exit;
    }

    // Quitar el prefijo base64 y decodificar la imagen
    $signatureData = str_replace('data:image/png;base64,', '', $signatureData);
    $signatureData = str_replace(' ', '+', $signatureData);
    $decodedSignature = base64_decode($signatureData);

    // Guardar la imagen de la firma en un archivo temporal
    $signatureFile = 'firma.png';
    file_put_contents($signatureFile, $decodedSignature);

    // Incluir autoload de Composer (asegúrate de haber instalado FPDI/FPDF con Composer)
    require_once('vendor/autoload.php');
    use setasign\Fpdi\Fpdi;

    // Crear una instancia de FPDI y cargar el PDF base
    $pdf = new Fpdi();
    $pageCount = $pdf->setSourceFile('template.pdf');
    $templateId = $pdf->importPage(1);
    $templateSize = $pdf->getTemplateSize($templateId);
    $pdf->AddPage($templateSize['orientation'], [$templateSize['width'], $templateSize['height']]);
    $pdf->useTemplate($templateId);

    // Agregar el nombre en una posición predefinida (ajusta X e Y según tu template)
    $pdf->SetFont('Helvetica', '', 12);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(50, 100);
    $pdf->Write(0, $name);

    // Insertar la imagen de la firma en una posición predefinida (ajusta X, Y y ancho según tu diseño)
    $pdf->Image($signatureFile, 50, 120, 50);

    // Sanitizar el nombre para usarlo como nombre de archivo (se reemplazan caracteres especiales)
    $sanitized = preg_replace('/[^A-Za-z0-9_\-]/', '_', $name);
    $outputFile = $sanitized . '.pdf';

    // Guardar el PDF generado en la raíz con el nombre del usuario
    $pdf->Output('F', $outputFile);

    echo "PDF generado exitosamente: <a href='{$outputFile}' target='_blank'>Descargar PDF</a>";
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Firma Digital</title>
  <style>
    canvas { border: 1px solid #000; }
  </style>
</head>
<body>
  <h1>Firma Digital</h1>
  <form id="signatureForm" method="post">
    <label for="name">Nombre Completo:</label>
    <input type="text" id="name" name="name" required><br><br>
    
    <canvas id="signatureCanvas" width="400" height="200"></canvas><br>
    <button type="button" id="clearCanvas">Limpiar</button>
    <br><br>
    <!-- Campo oculto para enviar la imagen del canvas -->
    <input type="hidden" name="signature" id="signatureInput">
    <input type="submit" value="Firmar y Generar PDF">
  </form>
  <script>
    // Configuración del canvas para capturar la firma
    var canvas = document.getElementById('signatureCanvas');
    var context = canvas.getContext('2d');
    var drawing = false;

    canvas.addEventListener('mousedown', function(e) {
      drawing = true;
      context.beginPath();
      context.moveTo(e.offsetX, e.offsetY);
    });

    canvas.addEventListener('mousemove', function(e) {
      if (drawing) {
        context.lineTo(e.offsetX, e.offsetY);
        context.stroke();
      }
    });

    canvas.addEventListener('mouseup', function(e) {
      drawing = false;
    });

    // Botón para limpiar el canvas
    document.getElementById('clearCanvas').addEventListener('click', function() {
      context.clearRect(0, 0, canvas.width, canvas.height);
    });

    // Antes de enviar el formulario, convierte el contenido del canvas a imagen base64
    document.getElementById('signatureForm').addEventListener('submit', function(e) {
      var dataURL = canvas.toDataURL('image/png');
      document.getElementById('signatureInput').value = dataURL;
    });
  </script>
</body>
</html>